HELP.PAS


Unit Help;
(* QuickPascal program *)

(**********************)
(**)    INTERFACE   (**)
(**********************)
TYPE
  StringPt = ^String;
  HelpStrings = ARRAY [1..500] of StringPt;
  HelpArray = ^HelpStrings;
  HelpSet = OBJECT
    size, number : Word;
    messages : HelpArray;
    PROCEDURE InitHelp(iSize : Word);
    FUNCTION  AddMessage(M : String): Boolean;
    FUNCTION  GetMessage(B : Word): String;
    PROCEDURE DoneWithHelp;
  END;

(**********************)
(**) IMPLEMENTATION (**)
(**********************)
  PROCEDURE HelpSet.InitHelp(iSize : Word);
  BEGIN
    self.size := iSize;
    self.number := 0;
    GetMem(self.messages, SizeOf(pointer)*iSize);
  END;

  FUNCTION HelpSet.AddMessage(M : String): Boolean;
  BEGIN
    IF self.number = self.size THEN AddMessage := FALSE
    ELSE
      BEGIN
	Inc(self.number);
	GetMem(self.messages^[self.number], succ(length(M)));
	self.messages^[self.number]^ := M;
	AddMessage := TRUE;
      END;
  END;

  FUNCTION HelpSet.GetMessage(B : Word): String;
  BEGIN
    IF B > self.number THEN GetMessage := ''
    ELSE
      GetMessage := self.messages^[B]^;
  END;

  PROCEDURE HelpSet.DoneWithHelp;
  VAR N : Word;
  BEGIN
    {Free up space taken by individual messages}
    FOR N := self.number downto 1 DO
      FreeMem(self.messages^[N],succ(length(self.messages^[N]^)));
    {Free up space used for array of pointers to messages}
    FreeMem(self.messages, SizeOf(Pointer)*self.size);
  END;

END.





